/*
	This is a part of the source code for Pro/DESKTOP.
	Copyright (C) 1998-1999 Parametric Technology Corporation.
	All rights reserved.
*/

//	ConstrainSize.cpp

#include <stdafx.h>

#include "CUtility.h"
#include "CConstraints.h"
#include "CApplication.h"


HRESULT ConstrainSize(ILine *line)
{

//	Creates a PPLinearDim constraint between the two end points of the given line

	START_METHOD("ConstrainSize")

	HRESULT status = CONV_SUCCESS;

	IGraphicDocument *activeGraphicDoc = NULL;
	IPartDocument *activePart = NULL;
	IWorkplane *activeWorkplane = NULL;
	ISketch *activeSketch = NULL;

	status = GetActivePartWorkplaneSketch(&activePart, &activeGraphicDoc, &activeWorkplane, &activeSketch);
	CHECK_RETURN_STATUS(status)

	ILine *aLine = NULL;

	if(line)
		aLine = CAST(ILine, line);

	IPoint *startPoint = NULL;
	IPoint *endPoint = NULL;

	status = aLine->GetStartPoint(&startPoint);
	CHECK_RETURN_STATUS(status)

	status = aLine->GetEndPoint(&endPoint);
	CHECK_RETURN_STATUS(status)

	IPPLinearDim *ppLinearDim = NULL;
	status = (GetCLASS(PPLinearDim))->CreatePPLinearDim(startPoint, endPoint, &ppLinearDim);
	CHECK_RETURN_STATUS(status)
	IConstraint *pConstraint = NULL;

	status = activeWorkplane->CreateConstraint(CAST(IGeomConstraint,ppLinearDim), &pConstraint);
	CHECK_RETURN_STATUS(status)

	END_METHOD("ConstrainSize")
}
